#line 3 "fleximesh1_spec.vsh"
vs .1 .1

; -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
; v0 = position
; v1 = blend weights
; v2 = blend indices
; v3 = normal
; v4 = texture coordinates
; -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

; -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
; r0.w = Last blend weight
; r1 = Blend indices
; r2 = Temp position
; r3 = Temp normal
; r4 = Blended position in camera space
; r5 = Blended normal in camera space
; r6 = view space vertex position
; r8.x = fog exponent
; -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

; -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
; Constants specified by the app;
;
; c0 = constants
; c1 = light_dir
; c2-5 = World * View * Projection
; c6 = Light diffuse colour
; c7 = Light ambient colour
; c8-11 = World matrix
; c12 = Specular color 
; c13 = Camera look vector
; c14 = Material diffuse colour
; c15-18 = Tex transform matrix 1
; c19-22 = Tex transform matrix 2
; c23-95 = Matrix palette
; -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

; -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
; oPos = Output position
; oD0 = Diffuse
; oD1 = Specular
; oT0 = texture coordinates
; -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --
#line 49 "fleximesh1_spec.vsh"
mul r1, v2.zyxw,	c[0].wwww
#line 53 "fleximesh1_spec.vsh"
dp3 r0.w, v1.xyz, c[0].xzz; 
add r0.w, -r0.w, c[0].x
#line 57 "fleximesh1_spec.vsh"
mov a0.x, r1.x
m3x3 r4, v0, c[a0.x + 24]
m3x3 r5, v3, c[a0.x + 24]
#line 62 "fleximesh1_spec.vsh"
mul r4, r4, v1.xxxx
mul r5, r5, v1.xxxx
#line 67 "fleximesh1_spec.vsh"
mov r11.x, c[a0.x + 24 + 0].w
mov r11.y, c[a0.x + 24 + 1].w
mov r11.z, c[a0.x + 24 + 2].w
mov r11.w, c[0].x
#line 73 "fleximesh1_spec.vsh"
mov a0.x, r1.y
m3x3 r2, v0, c[a0.x + 24]
m3x3 r3, v3, c[a0.x + 24]
#line 78 "fleximesh1_spec.vsh"
mad r4, r2, r0.wwww, r4
mad r5, r3, r0.wwww, r5
#line 82 "fleximesh1_spec.vsh"
add r4, r4, r11
#line 85 "fleximesh1_spec.vsh"
mov r4.w, c[0].x
m4x4 r6, r4, c[2]
mov oPos, r6

; Calculate the fog using D3DFOG_EXP
;mul r8.x, -c0.y, r6.z ; - (fog_exp_density * z_dist)
;exp r8.x, r8.x ; evaluate exponential function

mov r8.x, c[0].x ; HACK - just set it to 1 for now while investigating flashing characters on the strat map
mov oFog, r8.x

; Do the lighting calculation
dp3 r1.x, r5, -c[1] ; normal dot light
mul r0, r1.x, c[6] ; scale by light diffuse
mov r0.w, c[0].x ; set alpha to one

max r0, r0, c[0].z ; clamp if < 0
add r10, r0, c[7] ; Add in ambient
#line 105 "fleximesh1_spec.vsh"
m4x3 r0, r4, c[8] ; Transform point to world space 
add r0, -r0, c[12] ; Get a vector toward the camera position. This is the negative of the camera direction 
#line 109 "fleximesh1_spec.vsh"
dp3 r11.x, r0.xyz, r0.xyz ; Load the square into r11
rsq r11.xyz,	r11.x ; Get the inverse of the square
mul r0.xyz, r0.xyz, r11.xyz ; Multiply, r0 = - (camera vector)

mov r7, -c[1]
m3x3 r9, r7, c[8]	; Transform light dir into world space
add r2.xyz, r0.xyz, r9 ; Get half angle
#line 118 "fleximesh1_spec.vsh"
dp3 r11.x, r2.xyz, r2.xyz ; Load the square into r1
rsq r11.xyz,	r11.x ; Get the inverse of the square
mul r2.xyz, r2.xyz, r11.xyz ; Multiply, r2 = HalfAngle
m3x3 r1, r5, c[8] ; Transform normal to world space, put in r1
#line 124 "fleximesh1_spec.vsh"
dp3 r3.xyzw,	r1, r2
#line 127 "fleximesh1_spec.vsh"
;max r3, r3, c[0].zzzz
mul r3, r3, r3 ; 2 nd
mul r3, r3, r3 ; 4 th
mul r3, r3, r3 ; 8 th
mul r3, r3, r3 ; 16 th

mul r3, r3, r8.xxxx ; reduce specular by the fog factor
mul r3, r3, c[11]	; modulate by specular colour

;add r0, r10, r3 ; add to diffuse and ambient
mov r10.w, c[6].w ; add alpha
min oD0, r10, c[0].x ; clamp if > 1 and output
mov oD1, r3 ; output specular

; Copy texture coordinate
mov oT0, v4
